﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.SceneManagement;
using UnityEngine.UI;

//PauseMenu handles the pause menu UI
public class PauseMenu : MonoBehaviour
{
    //UI Elements
    public GameObject PauseMenuUI;
    public CustomButton CancelMissionButton;
    public Animator Animator;

    void Update()
    {
        if(Input.GetKeyDown(KeyCode.Escape))
        {
            //ESC was pressed, pause or resume based on the state
            if(GameManager.Instance.GameState == Constants.GameState.Paused)
            {
                Resume();
            }

            else if(GameManager.Instance.GameState == Constants.GameState.Playing)
            {
                Pause();
            }
        }
    }

    /// <summary>
    /// Pauses the game, by setting the game state and time scale, then animating
    /// </summary>
    private void Pause()
    {
        //Let's show the UI and set the game state
        PauseMenuUI.SetActive(true);
        GameManager.Instance.SetGameState(Constants.GameState.Paused);
        Time.timeScale = 0.0f;

        //Now play the SFX and begin animating
        AudioManager.Instance.PauseMusic();
        AudioManager.Instance.PlaySFX(AudioManager.Instance.LoadedFiles["GamePausedSFX"].Clip);
        Animator.Play("Show");

        //Set the cancel button state as appropriate
        if (!MissionsManager.Instance.IsOnMission)
        {
            CancelMissionButton.Disable();
        }

        else
        {
            CancelMissionButton.Enable();
        }
    }

    /// <summary>
    /// Resumes the game by restarting music and animating
    /// </summary>
    public void Resume()
    {
        AudioManager.Instance.UnPauseMusic();
        AudioManager.Instance.PlaySFX(AudioManager.Instance.LoadedFiles["GameResumedSFX"].Clip);
        Animator.Play("Hide");
    }

    /// <summary>
    /// Handler for the hide animation completing
    /// </summary>
    public void OnHideAnimationCompleted()
    {
        //We're hidden, so disable the UI and reset the game state
        PauseMenuUI.SetActive(false);
        GameManager.Instance.SetGameState(Constants.GameState.Playing);
        Time.timeScale = 1.0f;
    }

    /// <summary>
    /// Attempts to cancel the current mission
    /// </summary>
    public async void CancelMission()
    {
        if(await MessageBoxManager.Instance.Show("Cancel Mission?", "Are you sure you want to cancel the current mission?", new List<string>() { "NO, DON'T CANCEL", "YES, CANCEL" }) == 1)
        {
            //User confirmed, end the mission and resume the game
            MissionsManager.Instance.EndMission(false, false);
            Resume();
        }
    }

    public void QuitToMainMenu()
    {
        PauseMenuUI.SetActive(false);
        Time.timeScale = 1.0f;
        SceneManager.LoadScene("MenuScene");
    }
}
